
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:54:43 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief HASH external application ATP tests  
   *
   *  \version CRYS_ATP_TST_HASH_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_HASH_Acceptance.h"
#include "CRYS_Ext_ATP_HASH_Acceptance_test_vectors.h"
#include "CRYS_HOST_TST_HASH.h"

#include "DX_VOS_Mem.h"
#include <stdio.h>
#include <math.h>

/******** Defines **********/
/******** Enums **********/
/******** Typedefs **********/
/******** Global Data **********/
extern char FailureFunctionNameOut[FailureFunctionName_K_Size];
/***** Private function prototype ******/
/******** Public Functions **********/
CRYSError_t SEPQA_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
									   char         TST_FuncName[TST_FUNC_STRING_LEN],
									   char        *FailureFunctionNameOut_ptr,        
									   DxUint32_t   FuncNameMaxSize);

/******** Private Functions **********/
/***************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_HASH_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for HASH non integrated function,
 *  implemented as external SEP application                          .
 *  HASH modes                   - SHA1
 *  Vector sizes used (in bytes) - 1536                                 
 * Algorithm:       
 * 1. Call the SEPQA_HASH_NotIntegrated function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
 CRYSError_t CRYS_ExtApp_ATP_HASH_NON_integrated ( void )
{

    /*** TST Variables Definitions ****/
    int                     TST_index = 0;
    CRYSError_t             TST_TestStatus=0;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_HASH_NON_integrated";
    

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ExtApp_ATP_HASH_NON_integrated Tests ******** \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    
	SEP_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA1_mode;
                
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",SEP_HASH_Acceptance_TestData[TST_index].TST_Name,TST_index));
    CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)CRYS_HASH_SHA1_mode);

	/* calling the HASH ATP SEP function */ 
	/*----------------------------------*/
	TST_ATP_Error = SEPQA_HASH_NotIntegrated(SEP_HASH_Acceptance_TestData[TST_index].TST_OperationMode,
							SEP_HASH_Acceptance_TestData[TST_index].TST_input_data,
							SEP_HASH_Acceptance_TestData[TST_index].TST_input_dataSize,
							SEP_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data,
							SEP_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize,
							FailureFunctionNameOut,
							FailureFunctionName_K_Size);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_HASH_NotIntegrated",FailureFunctionNameOut,TST_MasterTestName);                   
                    
            
  return TST_TestStatus;
} /*End of test*/



/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
 /***************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_HASH_Integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for HASH non integrated function,
 *  implemented as external SEP application                          .
 *  HASH modes                   - SHA1
 *  Vector sizes used (in bytes) - 1536                                 
 * Algorithm:       
 * 1. Call the SEPQA_HASH_Integrated function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_ExtApp_ATP_HASH_Integrated ( void )
{

	/*** TST Variables Definitions ****/
	int                     TST_index = 0;
	CRYSError_t             TST_TestStatus=0;
	char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_HASH_Integrated";
	

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************* \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ExtApp_ATP_HASH_Integrated Tests ******** \n"));        
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ********************************************* \n \n"));

	/****************/
	/***** Start of test ********/
	/****************/

	SEP_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA1_mode;

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",SEP_HASH_Acceptance_TestData[TST_index].TST_Name,TST_index));
	CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)CRYS_HASH_SHA1_mode);

	TST_TestStatus = TESTPASS;

	/* calling the HASH ATP SEP function */ 
	/*-----------------------------------*/
	TST_ATP_Error = SEPQA_HASH_Integrated(SEP_HASH_Acceptance_TestData[TST_index].TST_OperationMode,
		SEP_HASH_Acceptance_TestData[TST_index].TST_input_data,
		SEP_HASH_Acceptance_TestData[TST_index].TST_input_dataSize,
		SEP_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data,
		SEP_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize,
		FailureFunctionNameOut,
		FailureFunctionName_K_Size);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_HASH_Integrated",FailureFunctionNameOut,TST_MasterTestName);                   


	return TST_TestStatus;            
} /*End of test*/

/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/




